<?php
require __DIR__.'/db.php';
header('Content-Type: application/json; charset=utf-8');

$login = trim($_POST['login'] ?? '');
$pswd  = trim($_POST['pswd']  ?? '');

if ($login === '' || $pswd === '') {
  http_response_code(400);
  echo json_encode(['ok'=>false,'msg'=>'Faltan credenciales']);
  exit;
}

try {
  $pdo = pdo();
  $stmt = $pdo->prepare("SELECT login, pswd, name FROM sec_users WHERE active='Y' AND login=? LIMIT 1");
  $stmt->execute([$login]);
  $u = $stmt->fetch();
  if (!$u) {
    http_response_code(401);
    echo json_encode(['ok'=>false,'msg'=>'Usuario no encontrado o inactivo']);
    exit;
  }
  // Si tu tabla guarda hash, reemplaza esta verificación por password_verify()
  if (!hash_equals((string)$u['pswd'], (string)$pswd)) {
    http_response_code(401);
    echo json_encode(['ok'=>false,'msg'=>'Contraseña incorrecta']);
    exit;
  }
  $_SESSION['agent_login'] = $u['login'];
  $_SESSION['agent_name']  = $u['name'] ?? $u['login'];
  // Estado: disponible y activo
  agent_upsert_state($u['login'], 'disponible', true, session_id());

  echo json_encode(['ok'=>true,'redirect'=>'dashboard.php']);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'msg'=>'Error: '.$e->getMessage()]);
}
