<?php
require __DIR__.'/db.php';
header('Content-Type: application/json; charset=utf-8');
agent_require_login();
$me = $_SESSION['agent_login'];
if (!is_supervisor($me)) { http_response_code(403); echo json_encode(['ok'=>false,'msg'=>'denegado']); exit; }

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$q = trim((string)($in['q'] ?? ''));
$estado = trim((string)($in['estado'] ?? ''));
$onlyActive = isset($in['only_active']) && (string)$in['only_active'] !== '' ? 1 : 0;

$sql = "SELECT e.login, COALESCE(u.name,e.login) AS nombre, e.estado, e.is_active, e.session_id, e.last_change, e.last_seen, e.ip
        FROM mesacontrol_agente_estado e
        LEFT JOIN sec_users u ON u.login=e.login
        WHERE 1=1";
$params = [];
if ($q !== ''){
  $sql .= " AND (e.login LIKE ? OR u.name LIKE ?)";
  $params[] = "%$q%"; $params[] = "%$q%";
}
if ($estado !== ''){
  $sql .= " AND e.estado = ?"; $params[] = $estado;
}
if ($onlyActive){
  $sql .= " AND e.is_active=1";
}
$sql .= " ORDER BY (e.estado='disponible') DESC, e.last_seen DESC";

$st = pdo()->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

echo json_encode(['ok'=>true, 'rows'=>$rows]);
