<?php
require __DIR__.'/db.php';
agent_require_login();
$me = $_SESSION['agent_login'];
if (!is_supervisor($me)) { http_response_code(403); echo 'Acceso denegado'; exit; }
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Supervisión — Estados de Agentes</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Lato:wght@400;700&display=swap" rel="stylesheet">
<style>
  body{font-family:'Lato',Arial,sans-serif;background:#f5f7fb;margin:0}
  .nav{display:flex;justify-content:space-between;align-items:center;padding:12px 16px;background:#101828;color:#fff}
  .wrap{max-width:1100px;margin:16px auto;background:#fff;border:1px solid #e7e8ec;border-radius:12px;padding:16px}
  .controls{display:flex;gap:8px;flex-wrap:wrap;margin-bottom:12px}
  input,select{padding:8px;border:1px solid #d0d5dd;border-radius:8px}
  table{width:100%;border-collapse:collapse}
  th,td{border-bottom:1px solid #eef1f4;padding:10px;text-align:left}
  th{background:#fafbfc;text-transform:uppercase;font-size:.85em;color:#475467}
  .badge{padding:4px 8px;border-radius:999px;font-weight:700;font-size:.85em}
  .b-disponible{background:#ecfdf3;color:#027a48}
  .b-pausa{background:#f2f4f7;color:#344054}
  .b-baño{background:#fdf2fa;color:#c11574}
  .b-comida{background:#fff6ed;color:#b93815}
  .b-entrenamiento{background:#eef4ff;color:#3538cd}
  .b-logout{background:#fee4e2;color:#b42318}
  .btn{padding:8px 10px;border:1px solid #d0d5dd;border-radius:8px;background:#f8fafc;font-weight:700;cursor:pointer}
  .btn:hover{background:#eef2f7}
  .muted{color:#667085;font-size:.9em}
</style>
</head>
<body>
  <div class="nav">
    <div><strong>Supervisión</strong></div>
    <div>Supervisor: <code><?php echo htmlspecialchars($me); ?></code> · <a href="dashboard.php" style="color:#fff">Mi Panel</a></div>
  </div>
  <div class="wrap">
    <div class="controls">
      <input type="search" id="q" placeholder="Buscar por login o nombre…">
      <select id="f">
        <option value="">Todos los estados</option>
        <option>disponible</option>
        <option>pausa</option>
        <option>baño</option>
        <option>comida</option>
        <option>entrenamiento</option>
        <option>logout</option>
      </select>
      <select id="onlyActive">
        <option value="">Activos + Inactivos</option>
        <option value="1">Solo activos</option>
      </select>
      <button class="btn" id="refresh">Refrescar</button>
    </div>

    <table id="tbl">
      <thead>
        <tr>
          <th>Agente</th>
          <th>Estado</th>
          <th>Duración</th>
          <th>Último latido</th>
          <th>IP</th>
          <th>Sesión</th>
          <th>Acciones</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>

    <p class="muted">Auto-actualiza cada 5 s. Si un agente no envía heartbeat por >120 s, se marcará logout por el scheduler/barrido.</p>
  </div>
<script>
const tbody = document.querySelector('#tbl tbody');
const q = document.getElementById('q');
const f = document.getElementById('f');
const onlyActive = document.getElementById('onlyActive');

function badge(estado){
  const cls = {
    'disponible':'b-disponible','pausa':'b-pausa','baño':'b-baño',
    'comida':'b-comida','entrenamiento':'b-entrenamiento','logout':'b-logout'
  }[estado]||'b-logout';
  return `<span class="badge ${cls}">${estado}</span>`;
}

function fmtDiff(ts){
  if(!ts) return '—';
  const d = new Date(ts.replace(' ', 'T'));
  const secs = Math.max(0, (Date.now() - d.getTime())/1000|0);
  const m = (secs/60)|0, s = secs%60; const h=(m/60)|0, mm=m%60;
  return h?`${h}h ${mm}m`:(m?`${m}m ${s}s`:`${s}s`);
}

async function load(){
  const res = await fetch('api_agents_list.php', {method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({
    q:q.value.trim(), estado:f.value, only_active: onlyActive.value
  })});
  const data = await res.json();
  render(data.rows||[]);
}

function render(rows){
  tbody.innerHTML = rows.map(r=>{
    return `<tr>
      <td><strong>${r.nombre||r.login}</strong><br><span class="muted">${r.login}</span></td>
      <td>${badge(r.estado)}</td>
      <td>${fmtDiff(r.last_change)}</td>
      <td>${fmtDiff(r.last_seen)} <span class="muted">(${r.last_seen||'—'})</span></td>
      <td>${r.ip||'—'}</td>
      <td><span class="muted">${(r.session_id||'').slice(0,10)}</span></td>
      <td>
        <button class="btn" onclick="act('${r.login}','disponible')">Disponible</button>
        <button class="btn" onclick="act('${r.login}','pausa')">Pausa</button>
        <button class="btn" onclick="act('${r.login}','logout')">Logout</button>
      </td>
    </tr>`
  }).join('');
}

async function act(login, estado){
  await fetch('api_super_action.php', {method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({login, estado})});
  await load();
}

document.getElementById('refresh').addEventListener('click', load);
f.addEventListener('change', load);
onlyActive.addEventListener('change', load);

setInterval(load, 5000);
load();
</script>
</body>
</html>
