<?php
// db.php - Conexión PDO + sesión persistente (cookie larga) sin timeout

define('DB_HOST', 'vento-credit.com');
define('DB_NAME', 'ventocredit_dbmain');
define('DB_USER', 'ventocredit_vadmin');
define('DB_PASS', 'Vent0Pass#word');

// 1) Sesión con vida larga (30 días) y sin gc mientras haya heartbeat
$lifetime = 60 * 60 * 24 * 30; // 30 días
ini_set('session.gc_maxlifetime', $lifetime);
session_set_cookie_params([
  'lifetime' => $lifetime,
  'path' => '/',
  'secure' => false, // pon true si usas HTTPS
  'httponly' => true,
  'samesite' => 'Lax',
]);
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}

function pdo(): PDO {
  static $pdo = null;
  if ($pdo) return $pdo;
  $dsn = 'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4';
  $pdo = new PDO($dsn, DB_USER, DB_PASS, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
  ]);
  return $pdo;
}

function agent_require_login() {
  if (empty($_SESSION['agent_login'])) {
    header('Location: login.php');
    exit;
  }
}

function sanitize_state(string $s): string {
  $allowed = ['logout','disponible','pausa','baño','comida','entrenamiento'];
  return in_array($s, $allowed, true) ? $s : 'logout';
}

function agent_upsert_state(string $login, string $estado, bool $active, ?string $sessionId=null) {
  $pdo = pdo();
  $estado = sanitize_state($estado);
  $sql = "INSERT INTO mesacontrol_agente_estado (login, estado, is_active, session_id, last_change, last_seen, user_agent, ip)
          VALUES (:login, :estado, :active, :sid, NOW(), NOW(), :ua, :ip)
          ON DUPLICATE KEY UPDATE
            estado=VALUES(estado),
            is_active=VALUES(is_active),
            session_id=VALUES(session_id),
            last_change=NOW(),
            last_seen=NOW(),
            user_agent=VALUES(user_agent),
            ip=VALUES(ip)";
  $stmt = $pdo->prepare($sql);
  $stmt->execute([
    ':login' => $login,
    ':estado' => $estado,
    ':active' => $active ? 1 : 0,
    ':sid' => $sessionId,
    ':ua' => $_SERVER['HTTP_USER_AGENT'] ?? null,
    ':ip' => $_SERVER['REMOTE_ADDR'] ?? null,
  ]);
}

function agent_touch_seen(string $login) {
  $pdo = pdo();
  $stmt = $pdo->prepare("UPDATE mesacontrol_agente_estado SET last_seen=NOW() WHERE login=?");
  $stmt->execute([$login]);
}

function is_supervisor(string $login): bool {
  // A) Lista blanca rápida (ajústala o ponla en una tabla)
  $ALLOW = ['admin','supervisor','luis']; // ← edita según tu operación
  if (in_array($login, $ALLOW, true)) return true;

  // B) (Opcional) valida por tabla sec_users si tienes columna/rol
  try {
    $pdo = pdo();
    $st = $pdo->prepare("SELECT 1 FROM sec_users WHERE login=? AND (group_id='supervisor' OR group_id='admin' OR priv_admin='Y') LIMIT 1");
    $st->execute([$login]);
    return (bool)$st->fetchColumn();
  } catch (Throwable $e) { return false; }
}
