<?php
require __DIR__.'/db.php';
header('Content-Type: application/json; charset=utf-8');
agent_require_login();
$me = $_SESSION['agent_login'];
if (!is_supervisor($me)) { http_response_code(403); echo json_encode(['ok'=>false,'msg'=>'denegado']); exit; }

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$login = trim((string)($in['login'] ?? ''));
$estado = sanitize_state((string)($in['estado'] ?? 'disponible'));

if ($login==='') { http_response_code(400); echo json_encode(['ok'=>false,'msg'=>'login requerido']); exit; }

try {
  agent_upsert_state($login, $estado, $estado!=='logout', null);
  echo json_encode(['ok'=>true]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'msg'=>$e->getMessage()]);
}
